<?php
// ++=========================================================================++
// || vBadvanced Links Directory v1.0.0 RC3                                   
// ||  2003-2004 vBadvanced.com & PlurPlanet, LLC - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || =-=-=-=+_++_+_+_+_+_+_+_+__+_+_++_+_+__+_+_+_+_++_+_+_+_+_+_+_+_=-=-=-=-=-
// || You are downloading a Ripped/Scripts that is not made by http://club2share.com staff.
// || Anything that happen because of running the Ripped/Scripts is not a responsibility of
// || clubshare staff. Downloading and opening the Ripped/Scripts is at your own risk.  Thank
// ||  you very much!  
// ||----------------------------------------------------------------------------
// ||Ripped By : Vb_IPB_RIP Member Of Club2Share
// ||Download  : Club2Share.Com
// ||Price     : $34.99
// ++ ========================================================================++

// ##################### Update Moderator Cache ########################
function update_links_mod_cache()
{
	global $DB_site;

	$mods = array();

	$getmods = $DB_site->query("SELECT * FROM " . TABLE_PREFIX ."links_moderator ORDER BY catid, username");
	while ($moderators = $DB_site->fetch_array($getmods))
	{
		$mods[] = $moderators;
	}
	build_datastore('links_mod_cache', serialize($mods));
	$DB_site->free_result($getmods);
	unset($moderators, $mods);
}

// ########################## Check URL #######################
function check_url($url)
{
	$status_array = array(
		'N/A'   => '<font color="yellow">Ikke HTTP</font>',
		'OK'    => '<font color="green">Valid hostname</font>',
		'FEJL'	=> '<font color="red">Invalid hostname</font>',
		'Dd'		=> '<font color="red">No response</font>',
		'100'		=> '<font color="yellow">Continue</font>',
		'101'		=> '<font color="yellow">Switching Protocols</font>',
		'200'		=> '<font color="green">OK</font>',
		'201'		=> '<font color="yellow">Created</font>',
		'202'		=> '<font color="green">Accepted</font>',
		'203'		=> '<font color="red">Non-Authoritative Information</font>',
		'204'		=> '<font color="red">No Content</font>',
		'205'		=> '<font color="yellow">Reset Content</font>',
		'206'		=> '<font color="yellow">Partial Content</font>',
		'300'		=> '<font color="yellow">Multiple Choices</font>',
		'301'		=> '<font color="red">Moved Permanently</font>',
		'302'		=> '<font color="green">Found</font>',
		'303'		=> '<font color="yellow">See Other</font>',
		'304'		=> '<font color="yellow">Not Modified</font>',
		'305'		=> '<font color="yellow">Use Proxy</font>',
		'307'		=> '<font color="yellow">Temporary Redirect</font>',
		'400'		=> '<font color="red">Bad Request</font>',
		'401'		=> '<font color="yellow">Unauthorized</font>',
		'402'		=> '<font color="yellow">Payment Required</font>',
		'403'		=> '<font color="red">Forbidden</font>',
		'404'		=> '<font color="red">Not Found</font>',
		'405'		=> '<font color="yellow">Method Not Allowed</font>',
		'406'		=> '<font color="yellow">Not Acceptable</font>',
		'407'		=> '<font color="yellow">Proxy Authentication Required</font>',
		'408'		=> '<font color="yellow">Request Timeout</font>',
		'409'		=> '<font color="yellow">Conflict</font>',
		'410'		=> '<font color="red">Gone</font>',
		'411'		=> '<font color="yellow">Length Required</font>',
		'412'		=> '<font color="yellow">Precondition Failed</font>',
		'413'		=> '<font color="yellow">Request Entity Too Large</font>',
		'414'		=> '<font color="yellow">Request-URI Too Long</font>',
		'415'		=> '<font color="yellow">Unsupported Media Type</font>',
		'416'		=> '<font color="yellow">Requested Range Not Satisfiable</font>',
		'417'		=> '<font color="yellow">Expectation Failed</font>',
		'500'		=> '<font color="yellow">Internal Server Error</font>',
		'501'		=> '<font color="yellow">Not Implemented</font>',
		'502'		=> '<font color="yellow">Bad Gateway</font>',
		'503'		=> '<font color="yellow">Service Unavailable</font>',
		'504'		=> '<font color="yellow">Gateway Timeout</font>',
		'505'		=> '<font color="yellow">HTTP Version Not Supported</font>'
	);

	$urlArray = parse_url($url);
	if (!$urlArray['port'])
	{
		$urlArray['port'] = 80;
	}
	if (!$urlArray['path'])
	{
		$urlArray['path'] = '/';
	}
	$sock = @fsockopen($urlArray['host'], $urlArray['port'], $errnum, $errstr, 10);
	if (!$sock)
	{
	  $return['code'] = 'Dd';
	}
	else
	{
		$dump .= "HEAD $urlArray[path] HTTP/1.1\r\n";
		$dump .= "User-Agent: Link Checker\r\n";
		$dump .= "Host: $urlArray[host]\r\nConnection: close\r\n";
		$dump .= "Connection: close\r\n\r\n";
		@fputs($sock, $dump);
		while($str = @fgets($sock, 1024))
		{
			if (eregi("^http/[0-9]+.[0-9]+ ([0-9]{3}) [a-z ]*", $str))
			{
			  $return['code'] = trim(eregi_replace("^http/[0-9]+.[0-9]+ ([0-9]{3}) [a-z ]*", "\\1", $str));
			}
			if (eregi('^Content-Type: ', $str))
			{
				$return['contentType'] = trim(eregi_replace('^Content-Type: ', '', $str));
			}
		}
		@fclose($sock);
		flush();
	}
	$return['status'] = $status_array[$return['code']];
	return $return;
}

// ######################### Make Directory Select Field ######################
function print_directory_select($selectname, $selectedid = 0, $nonevalue = '', $title = '', $disablecat = false, $nonele = 0)
{
	global $datastore;

	if (!$nonevalue)
	{
		$nonevalue = $vbphrase['none'];
	}

  echo '<tr class="' . fetch_row_bgclass() . '" valign="top">';
  echo '<td>' . $title . ':</td>';
  echo '<td>';

  echo '<select class="bginput" name="' . $selectname . '" size="1">';
  echo '<option value="' . $nonele . '">' . $nonevalue . '</option>';
	$options = print_dir_select($selectedid, $disablecat);

	echo $options;
  echo '</select>';
 	echo '</td></tr>';
	unset($options);
}


// ########################## Check Link Errors ##########################
function verify_link_errors()
{
	global $DB_site, $bbuserinfo, $username, $catid, $url, $name;
	
	if (!$catid)
	{
		print_stop_message('adv_links_must_choose_dir_for_link');
	}
	if (($url == 'http://' OR !$url) OR !$name)
	{
		print_stop_message('required_field_missing_be_sure_entered_all');
	}
}

// ######################### Remove Links In Category #########################
function remove_links_in_cat($catid)
{
	global $DB_site;

	$linkid = array();

	$linkids = $DB_site->query("SELECT linkid FROM " . TABLE_PREFIX . "links WHERE catid IN ($catid)");
	while ($links = $DB_site->fetch_array($linkids))
	{
		$linkid[] = $links['linkid'];
	}

	if (!empty($linkid))
	{
		delete_links($linkid);
	}
}


// ######################### Print Duplicate Links ###########################
function print_dupelinks($link)
{
	global $vboptions, $vbphrase;
	$cell = array();
	$cell[] = '<nobr><span class="smallfont"><label for="deletelink[' . $link['linkid'] . ']"><input id="deletelink[' . $link['linkid'] . ']" name="deletelink[' . $link['linkid'] . ']" type="radio" value="1" />' . $vbphrase['yes'] . '</label> <label for="nodeletelink[' . $link['linkid'] . ']"><input checked="checked" id="nodeletelink[' . $link['linkid'] . ']" name="deletelink[' . $link['linkid'] . ']" type="radio" value="0" />' . $vbphrase['no'] . '</label></span></nobr>';
	$cell[] = '<span class="smallfont">' . $link['linkid'] . '</span>';
	$cell[] = stripslashes($link['name']);
	$cell[] = '<span class="smallfont">' . stripslashes($link['title']) . '</span>';
	$cell[] = '<div align="right" class="smallfont">' . vbdate($vboptions['dateformat'], $link['dateline']) . '<br />' . $vbphrase['by'] . ' ' . iif($link['username'], '<a href="' . $vboptions['bburl'] . '/member.php?' . $session['sessionurl'] . 'u=' . $link['userid'] . '" target="_blank">' . stripslashes($link['username']) . '</a>', $vbphrase['unregistered']) . '</div>';
	print_cells_row($cell, '', '', -2, 'middle');
}

// ################# Construct dupelicate links ######################
function find_duplicates($linkarray, $url)
{
	global $link, $counter, $donearray, $vbphrase;

	if (empty($donearray))
	{
		$donearray = array();
	}
	$counter = 0;
	foreach ($linkarray AS $links)
	{

		$links['url'] = str_replace('www.', '', $links['url']);
		$url = str_replace('www.', '', $url);

		if ($links['url'] == $url AND $links['linkid'] != $link['linkid'] AND !in_array($links['linkid'], $donearray))
		{
			$counter++;
			$donearray[] = $links['linkid'];
			$donearray[] = $link['linkid'];
			if ($counter == 1)
			{
				print_table_break();
				print_table_header('<a href="' . $link['url'] . '" target="blank">' . $link['url'] . '</a>', 6);
				print_cells_row(array($vbphrase['delete'], $vbphrase['id'], $vbphrase['title'], $vbphrase['directory'], ''  . $vbphrase['date_added'] . ' / ' . $vbphrase['submitted_by'] . ''), 1, tcat);
				print_dupelinks($link);
			}				
			print_dupelinks($links);
		}
	}
}

// ##################### Print Suspend / Delete Row ###########################
function print_sus_del_row($link, $delete = 0)
{
	global $vboptions, $vbphrase;
	$cell = array();
	if ($delete)
	{
		$cell[] = '<input checked="checked" name="dellink[' . $link['linkid'] . ']" type="checkbox" value="1" />';
	}
	else
	{
		$cell[] = '<input checked="checked" name="suslink[' . $link['linkid'] . ']" type="checkbox" value="1" />';
	}
	$cell[] = stripslashes($link['name']);
	$cell[] = stripslashes($link['title']);
	$cell[] = '<div align="right" class="smallfont"><nobr>' . vbdate($vboptions['dateformat'] . ' ' . $vboptions['timeformat'], $link['dateline']) . '</nobr><br />by ' . iif($link['username'], '<a href="' . $vboptions['bburl'] . '/member.php?' . $session['sessionurl'] . 'u=' . $link['userid'] . '" target="_blank">' . stripslashes($link['username']) . '</a>', $vbphrase['unregistered']) . '</div>';
	print_cells_row($cell, '', '', -1);
}

// ######################## Rebuild Parents ############
function rebuild_parents($catid = 0, $echooutput = false)
{
	global $DB_site, $parentlist;

	$cats = array();

	$getcats = $DB_site->query("SELECT catid, title, parent FROM " . TABLE_PREFIX . "links_categories ORDER BY parent");
	while ($catinfo = $DB_site->fetch_array($getcats))
	{
		$cats[] = $catinfo;
	}
	foreach($cats AS $cat)
	{
		if ($catid != 0 AND $cat['catid'] != $catid)
		{
			continue;
		}
		$parentlist = array();
		$parentlist[] = $cat['catid'];
		construct_parents($cats, $cat['parent']);
		$plist = implode(',', $parentlist);

		$DB_site->query("UPDATE " . TABLE_PREFIX . "links_categories SET parentlist = '$plist' WHERE catid = '$cat[catid]'");

		if ($echooutput)
		{
			echo "Updated $cat[title] - ($plist)<br />";
		}
	}
}


// ########################### Find Parent Directories ########################
function construct_parents($catinfo, $catid)
{
	global $DB_site, $parentlist;

	foreach ($catinfo AS $subs)
	{
		if ($subs['catid'] == $catid)
		{
			$parentlist[] = $subs['catid'];
			construct_parents($catinfo, $subs['parent']);
		}
	}
	return $parentlist;

}

// ################# Print Directories For Permissions Page ###################
function construct_directories_perms($catinfo, $cat = 0)
{
	global $counter, $usergroupcache, $vbphrase, $directories;

	if ($catinfo)
	{
		$catarray = array();
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$counter++;
				$cats['level'] = $counter;

				$directories .= '<ul class="lsq"><li><b>' . $cats['title'] . '</b></li>';
				$directories .= '<ul class="usergroups">';
				
				foreach ($usergroupcache AS $group)
				{
					$directories .= '<li>[<a href="vba_links_admin.php?do=editdirectoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';
				}
				
				$directories .=  '</ul><br />';

				construct_directories_perms($catinfo, $cats['catid']);
				$directories .=  '</ul>';
				$counter--;
			}
		}
	}
	return $directories;
}

?>